/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSink;
import net.coobird.thumbnailator.util.BufferedImages;
import net.coobird.thumbnailator.util.ThumbnailatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImageSink
extends AbstractImageSink<File> {
    private File destinationFile;
    private final boolean allowOverwrite;

    public FileImageSink(File file) {
        this(file, true);
    }

    public FileImageSink(File file, boolean bl) {
        if (file == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.destinationFile = file;
        this.outputFormat = FileImageSink.getExtension(file);
        this.allowOverwrite = bl;
    }

    public FileImageSink(String string2) {
        this(string2, true);
    }

    public FileImageSink(String string2, boolean bl) {
        if (string2 == null) {
            throw new NullPointerException("File cannot be null.");
        }
        this.destinationFile = new File(string2);
        this.outputFormat = FileImageSink.getExtension(this.destinationFile);
        this.allowOverwrite = bl;
    }

    private static boolean isMatchingFormat(String string2, String string3) {
        String[] stringArray;
        ImageWriter imageWriter;
        if (string2 == null || string3 == null) {
            return false;
        }
        try {
            imageWriter = ImageIO.getImageWritersByFormatName(string2).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        for (String string4 : stringArray = imageWriter.getOriginatingProvider().getFileSuffixes()) {
            if (!string3.equalsIgnoreCase(string4)) continue;
            return true;
        }
        return false;
    }

    private static String getExtension(File file) {
        String string2 = file.getName();
        if (string2.indexOf(46) != -1 && string2.lastIndexOf(46) != string2.length() - 1) {
            int n = string2.lastIndexOf(46);
            return string2.substring(n + 1);
        }
        return null;
    }

    @Override
    public String preferredOutputFormatName() {
        Iterator<ImageReader> iterator2;
        String string2 = FileImageSink.getExtension(this.destinationFile);
        if (string2 != null && (iterator2 = ImageIO.getImageReadersBySuffix(string2)).hasNext()) {
            try {
                return iterator2.next().getFormatName();
            }
            catch (IOException iOException) {
                return ThumbnailParameter.ORIGINAL_FORMAT;
            }
        }
        return this.outputFormat;
    }

    @Override
    public void write(BufferedImage bufferedImage) throws IOException {
        FileOutputStream fileOutputStream;
        List<String> list2;
        Iterator<Object> iterator2;
        super.write(bufferedImage);
        String string2 = FileImageSink.getExtension(this.destinationFile);
        String string3 = this.outputFormat;
        if (!(string3 == null || string2 != null && FileImageSink.isMatchingFormat(string3, string2))) {
            this.destinationFile = new File(this.destinationFile.getAbsolutePath() + "." + string3);
        }
        if (!this.allowOverwrite && this.destinationFile.exists()) {
            throw new IllegalArgumentException("The destination file exists.");
        }
        if (string3 == null && string2 != null && (iterator2 = ImageIO.getImageReadersBySuffix(string2)).hasNext()) {
            string3 = ((ImageReader)iterator2.next()).getFormatName();
        }
        if (string3 == null) {
            throw new UnsupportedFormatException(string3, "Could not determine output format.");
        }
        iterator2 = ImageIO.getImageWritersByFormatName(string3);
        if (!iterator2.hasNext()) {
            throw new UnsupportedFormatException(string3, "No suitable ImageWriter found for " + string3 + ".");
        }
        ImageWriter imageWriter = (ImageWriter)iterator2.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam.canWriteCompressed() && this.param != null) {
            imageWriteParam.setCompressionMode(2);
            if (this.param.getOutputFormatType() != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
                imageWriteParam.setCompressionType(this.param.getOutputFormatType());
            } else {
                list2 = ThumbnailatorUtils.getSupportedOutputFormatTypes(string3);
                if (!list2.isEmpty()) {
                    imageWriteParam.setCompressionType((String)list2.get(0));
                }
            }
            if (!Float.isNaN(this.param.getOutputQuality())) {
                imageWriteParam.setCompressionQuality(this.param.getOutputQuality());
            }
        }
        if ((list2 = ImageIO.createImageOutputStream(fileOutputStream = new FileOutputStream(this.destinationFile))) == null || fileOutputStream == null) {
            throw new IOException("Could not open output file.");
        }
        if (string3.equalsIgnoreCase("jpg") || string3.equalsIgnoreCase("jpeg") || string3.equalsIgnoreCase("bmp")) {
            bufferedImage = BufferedImages.copy(bufferedImage, 1);
        }
        imageWriter.setOutput(list2);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        imageWriter.dispose();
        list2.close();
        fileOutputStream.close();
    }

    @Override
    public File getSink() {
        return this.destinationFile;
    }
}

